Imports System.Data.OleDb

Public Class WebForm1
  Inherits System.Web.UI.Page


#Region " Web Form Designer Generated Code "

  'This call is required by the Web Form Designer.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()

  End Sub

  Private Sub Page_Init(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Init
    'CODEGEN: This method call is required by the Web Form Designer
    'Do not modify it using the code editor.
    InitializeComponent()
  End Sub

#End Region

  Private Function ConnectionString() As String
    Return "Provider=Microsoft.Jet.OLEDB.4.0;" & _
      "Data Source=c:\inetpub\wwwroot\CodeDatabase\data\CodeDatabase.mdb"
  End Function

  Private Function Query() As String
    Return "SELECT * FROM SOURCE"
  End Function

  Private Function OrderBy(ByVal SortColumn As String) As String
    If (SortColumn = "") Then
      Return ""
    Else
      Return " ORDER BY " & SortColumn
    End If
  End Function

  Private Function Query(ByVal SortColumn As String) As String
    Return Query() & OrderBy(SortColumn)
  End Function

  Private Sub Page_Load(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MyBase.Load
    'Put user code to initialize the page here
    If (IsPostBack()) Then Exit Sub
    BindData(Query())
  End Sub

  Private Sub DataGrid1_PageIndexChanged( _
  ByVal source As System.Object, _
  ByVal e As System.Web.UI.WebControls. _
  DataGridPageChangedEventArgs)

    DataGrid1.CurrentPageIndex = e.NewPageIndex
    BindData(Query(FSortColumn))
  End Sub

  Protected WithEvents DataGrid1 As _
    System.Web.UI.WebControls.DataGrid
  Protected WithEvents Label1 As System.Web.UI.WebControls.Label
  Protected WithEvents PlaceHolder1 As System.Web.UI.WebControls.PlaceHolder

  Private FSortColumn As String = ""
  Private Property SortColumn() As String
    Get
      Return FSortColumn
    End Get
    Set(ByVal Value As String)
      FSortColumn = Value
      Changed()
    End Set
  End Property

  Private Function GetDataTable(ByVal SQL As String, _
    ByVal TableName As String) As DataTable

    Dim Adapter As New OleDbDataAdapter(SQL, ConnectionString())
    Dim DataSet As New DataSet()
    Adapter.Fill(DataSet, TableName)
    Return DataSet.Tables(TableName)

  End Function

  Private Overloads Sub BindData(ByVal SQL As String)
    Dim Table As DataTable = GetDataTable(SQL, "Source")
    BindData(Table)
    AddToCache(FSortColumn, Table)
  End Sub

  Private Overloads Sub BindData(ByVal Table As DataTable)
    DataGrid1.DataSource = Table
    DataGrid1.DataBind()
  End Sub

  Private Sub AddToCache(ByVal Column As String, ByVal Table As DataTable)
    If Not (CachedTable(Column) Is Nothing) Then Exit Sub
    CachedTable(Column) = Table
  End Sub

  Private Property CachedTable(ByVal Column As String) As DataTable
    Get
      Return CType(Cache(Column), DataTable)
    End Get
    Set(ByVal Value As DataTable)
      If (Column = "") Or (Value Is Nothing) Then Exit Property
      Cache.Insert(Column, Value)
    End Set
  End Property

  Private Sub Changed()

    If (CachedTable(FSortColumn) Is Nothing) Then
      BindData(Query(FSortColumn))
      Label1.Text = "Ran Query"
    Else
      BindData(CachedTable(FSortColumn))
      Label1.Text = "From Cache"
    End If

  End Sub

  Private Sub DataGrid1_SortCommand( _
    ByVal source As Object, ByVal e As _
    System.Web.UI.WebControls.DataGridSortCommandEventArgs) _
    Handles DataGrid1.SortCommand

    SortColumn = e.SortExpression
  End Sub

  Private ReadOnly Property FormattedColumn() As String
    Get
      If (FSortColumn = "") Then
        Return "Unordered List"
      Else
        Return "Ordered List by " & FSortColumn
      End If
    End Get
  End Property

  Protected Overrides Sub Render( _
    ByVal writer As System.Web.UI.HtmlTextWriter)

    MyBase.Render(writer)
    writer.WriteBeginTag("center") : writer.Write(HtmlTextWriter.TagRightChar)

    writer.WriteBeginTag("i") : writer.Write(HtmlTextWriter.TagRightChar)
    writer.Write(FormattedColumn)
    writer.WriteEndTag("i")

    writer.WriteEndTag("center")

  End Sub

  Private Sub DataGrid1_SelectedIndexChanged(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles DataGrid1.SelectedIndexChanged
    Label1.Text = DataGrid1.SelectedIndex.ToString()
  End Sub


End Class
